import jsonlines
import sys


path = sys.argv[1]


thres = {"< 0.1": 0,
         "0.1-0.2": 0,
         "0.2-0.3": 0,
         "0.3-0.4": 0,
         "0.4-0.5": 0,
         "0.5-0.6": 0,
         "0.6-0.7": 0,
         "0.7-0.8": 0,
         "0.8-0.9": 0,
         "0.9-1.0": 0,
         ">= 1.0": 0,}
data = [d for d in jsonlines.open(path, "r")]

for d in data:
    for key in d["K"]:
        if key == "vanilla":
            continue
        else:
            if d['K'][key] < 0.1:
                thres["< 0.1"] += 1
            elif d['K'][key] < 0.2:
                thres["0.1-0.2"] += 1
            elif d['K'][key] < 0.3:
                thres["0.2-0.3"] += 1
            elif d['K'][key] < 0.4:
                thres["0.3-0.4"] += 1
            elif d['K'][key] < 0.5:
                thres["0.4-0.5"] += 1
            elif d['K'][key] < 0.6:
                thres["0.5-0.6"] += 1
            elif d['K'][key] < 0.7:
                thres["0.6-0.7"] += 1
            elif d['K'][key] < 0.8:
                thres["0.7-0.8"] += 1
            elif d['K'][key] < 0.9:
                thres["0.8-0.9"] += 1
            elif d['K'][key] < 1.0:
                thres["0.9-1.0"] += 1
            else:
                thres[">= 1.0"] += 1

easy, normal, hard, unfair = 0, 0, 0, 0
easy += thres["0.1-0.2"] + thres["0.2-0.3"] + thres["0.3-0.4"]
normal += thres["0.4-0.5"] + thres["0.5-0.6"] + thres["0.6-0.7"]
hard += thres["0.7-0.8"] + thres["0.8-0.9"] + thres["0.9-1.0"]
unfair += thres[">= 1.0"]

print(f"easy: {easy}")
print(f"normal: {normal}")
print(f"hard: {hard}")
print(f"unfair: {unfair}")




